*** COS 2018 11, last update 2023 01  
           
program define dq_dm_stn, rclass  
syntax varlist, [row(string)  recodeminprop(real .95) tablename(string)  indent(int 0)]  
if "`tablename'"==""  	local tablename="integtable_studydata"  
if "`row'"==""  		local tablename="integtablerows_studydata"  
local indent=`indent'+5  
local adoname "dq_dm_stn"  
local text_i "di as text _n "  					  
	          
local var `varlist'				  
local convertsuccess=0			  
tempvar miss_var  
qui egen `miss_var'=rowmiss(`var')  
qui count if `miss_var'==0  
local validcount=r(N)  
	          
if `recodeminprop'>0 {  
	*	The number of missing values + the number of converted string values must be equal to at least a specified percentage of the values, default 95%  
	if `validcount'>0 {  
		tempvar numericconvert  
		qui gen `numericconvert'=real(`var')												  
		*Generate a test variable for succesfull conversions  
		tempvar numericconvertcheck  
		qui gen `numericconvertcheck'=0  
		qui replace `numericconvertcheck'=1 	if  `numericconvert'<.						  
		         
		* Check whether conversion worked = no missing on original variable is no missing on converted variable (REMOVED & `var' <.)  
		qui count if `numericconvertcheck'==1 & `miss_var'==0  
		local convertnum=r(N)  
		         
		local convertprop=`convertnum'/`validcount'  
		local alphabet "`c(alpha)' `c(ALPHA)'" 							 					  
		foreach letter of local alphabet {								 					  
			qui replace `var'= lower(".`letter'") if `var'==".`letter'"						  
		}	       
		         
		if `convertprop'>=`recodeminprop' {													  
			qui destring `var',  force replace												  
			qui replace `var'=`numericconvert' if missing(`numericconvert')					  
			local convertsuccess=1															  
			        
		}        
		if `convertprop'<`recodeminprop'{													  
		}        
	}         
}          
if `recodeminprop'==0 {  
	local varlabel: var label `var'  
	qui clonevar __e4k8q_=`var'  
	drop `var'  
	qui encode __e4k8q_, gen(`var')  
	qui drop __e4k8q_  
	lab var `var' "`varlabel'"  
	qui capture confirm scalar scalelevel_$$`var'  
	if _rc>0  scalar scalelevel_$$`var'="nominal $assigned_1"  
	local convertsuccess=1																  
	local convertnum = `validcount'														  
}          
if `convertsuccess'==1 {  
	*** DQ_action_decision: 	DQ_INT_9 - action	  
	dq_out_add,  tablename("`tablename'") row(`row') columns(3) ///  
		colcontent1("$Action_1") colcontent2("String $Variable_1 `var'") colcontent3($DQ_INT_action_9 `convertnum' / `validcount') ///  
		vartype(`vartype')  indent(`indent') 				  
}          
return local convertsuccess=`convertsuccess'	  
           
end        
